﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="uploader.aspx.cs" Inherits="GUI.Web.Base.Scripts.tinymce.plugins.wizdomImagePicker.uploader" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <script src="//ajax.aspnetcdn.com/ajax/jQuery/jquery-2.1.1.min.js"></script>
</head>
    <body class="bootstrap-wrapper">
        <style type="text/css">
        body, html {
            background-color: transparent !important;
            background:none !important;
            margin: 0;
            overflow: hidden;
            font-family: LatoWeb,"Segoe UI",Segoe,Tahoma,Helvetica,Arial,sans-serif;
        }
        

        	@font-face {
        		font-family: 'streamline-icons';
        		src: url('../../../../fonts/streamline/streamline-icons.ttf?iyun5n') format('truetype'), url('../../../../fonts/streamline/streamline-icons.woff?iyun5n') format('woff'), url('../../../../fonts/streamline/streamline-icons.svg?iyun5n##{$icon--streamline-font-family}') format('svg');
        		font-weight: normal;
        		font-style: normal;
        		font-display: block;
        	}

        	@font-face {
        		font-family: 'Glyphicons Halflings';
        		src: url(../../../../fonts/glyphicons-halflings-regular.eot);
        		src: url(../../../../fonts/glyphicons-halflings-regular.eot?#iefix) format('embedded-opentype'),url(../../../../fonts/glyphicons-halflings-regular.woff2) format('woff2'),url(../../../../fonts/glyphicons-halflings-regular.woff) format('woff'),url(../../../../fonts/glyphicons-halflings-regular.ttf) format('truetype'),url(../../../../fonts/glyphicons-halflings-regular.svg#glyphicons_halflingsregular) format('svg')
        	}

            /* custom button behaviour from style.scss */

            .btn-default, .btn-default:focus, .btn-default:visited {
                color: #252423;
                border: 1px solid #BEBBB8;
                background-color: transparent!important;
            }

            .btn-default:active, .btn-default:focus:active, .btn-default:focus:hover, .btn-default:hover, .btn-default:visited:active, .btn-default:visited:hover {
                color: #252423;
                border: 1px solid #BEBBB8;
                background-color: #F4F4F4 !important;
            }

            .btn {
                border-radius: 3px!important;
                line-height: 21px!important;
                padding: 9px 12px!important;
                font-size: 15px!important;
            }

            .btn>i, .btn>span {
                padding-right: 8px;
            }

            .streamline.icon-download-bottom::before {
                content: "\e916";
            }



        	.streamline::before {
        		/* use !important to prevent issues with browser extensions that change fonts */
        		font-family: 'streamline-icons' !important;
        		speak: none;
        		font-style: normal;
        		font-weight: normal;
        		font-variant: normal;
        		text-transform: none;
        		line-height: 1;
        		/* Better Font Rendering =========== */
        		-webkit-font-smoothing: antialiased;
        		-moz-osx-font-smoothing: grayscale;
        	}


        	.glyphicon {
        		position: relative;
        		top: 1px;
        		display: inline-block;
        		font-family: 'Glyphicons Halflings';
        		font-style: normal;
        		font-weight: 400;
        		line-height: 1;
        		-webkit-font-smoothing: antialiased;
        		-moz-osx-font-smoothing: grayscale
        	}

        	.glyphicon-camera:before {
        		content: "\e046"
        	}                                                                                                                                                                                                                                                                                                                                                                                                                                                         
        .glyphicon-picture:before {content: "\e060"}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
        .glyphicon-open:before{content:"\e167"}
            .uploader-form {
                height: 41px;
            }

            .fileinput-button {
                overflow: hidden;
                position: relative;
            }

            .fileinput-button input {
                -ms-filter: 'alpha(opacity=0)';
                cursor: pointer;
                direction: ltr;
                font-size: 200px;
                margin: 0;
                opacity: 0;
                position: absolute;
                right: 0;
                top: 0;
            }

            .fileupload-hidden-button {
                height: 20px;
                width: 40px;
            }

            .submitfile-hidden-button {
                display: none;
                height: 41px;
            }

            input[type="file"] {
                display: none;
            }

            .custom-file-upload {
                
                display: inline-block;
                
                cursor: pointer;
            }

    </style>
        <form id="form1" runat="server" class="uploader-form">

            <span class="fileinput-button">

                <!-- The file input field used as target for the file upload widget -->
                <label for="fileUpload" class="btn btn-default custom-file-upload"><i class="streamline icon-download-bottom"></i>Upload</label>
                <asp:FileUpload runat="server" 
                                class="fileupload-hidden-button" 
                                ClientIDMode="Static" 
                                ID="fileUpload" 
                                onchange="submitFile(this);"/>   
                <asp:Button runat="server"
                            class="submitfile-hidden-button btn btn-sm" 
                            OnClick="SubmitFile_Click" 
                            ID="btnSubmit" 
                            Text="Load"/> 
                <asp:HiddenField runat="server" ID="Authorization" />
            </span>

    <script>
        var validFilesTypes = <%=allowedtypes.ToString()%>;
        var validate = <%= Request.QueryString["validate"] != null ? (Request.QueryString["validate"].ToLower() == "false" ? "false" : "true") : "true" %>;

        var token = getToken();
        if(token)
	        setToken();


        function setToken() {
            var tokenField = document.getElementById('<%=Authorization.ClientID%>');
            tokenField.value = token;
        }

        function getToken() {
			for (var i = 0; i < sessionStorage.length; i++) {
				try {
					var obj = JSON.parse(sessionStorage.getItem(sessionStorage.key(i)));
					var hasToken = obj.hasOwnProperty("accessToken");
					if (hasToken) {
						return obj["accessToken"];
					}
				}
				catch (e) { }
			}
		}
        
		function submitFile(file) {
			if (!validate || CheckExtension(file)) {
				$("#btnSubmit").click();
			}
        };

		function CheckExtension(file) {
			var filePath = file.value;
			var ext = filePath.substring(filePath.lastIndexOf('.')).toLowerCase();
			var isValidFile = false;

			for (var i = 0; i < validFilesTypes.length; i++) {
				if (ext == validFilesTypes[i].toLowerCase()) {
					isValidFile = true;
					break;
				}
			}

			if (!isValidFile) {
				file.value = null;
				alert("Invalid File Format.");
			}

			return isValidFile;
		}
	</script>
    </form>
</body>
</html>